<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

use App\Models\Admin;
use App\Models\Category;
use App\Models\Skill;
use App\Models\Location;
use App\Models\Job;
use App\Models\Announcement;
use App\Models\Plan;
use App\Models\User;
use App\Models\Slider;
use App\Models\Keyword;
use App\Models\Banneradvertisement;
use App\Models\Importjob;
use App\Models\Site_setting;
use App\Models\Blog;
use App\Models\Page;

use Session;
use DateTime;

class MetaController extends Controller
{

    public function homepageMeta(Request $request){
        
        $homepageMetaData = Admin::where('id', 1)->first();
        
        $data=[
            
            'home_meta_title' => $homepageMetaData->default_title,
            'home_meta_description' => $homepageMetaData->default_description,
            'home_meta_keyword' => $homepageMetaData->default_keyword
            ];
            
        return Response(['response' => $data, 'status' => 200], 200);
    }
    
    public function searchpageMeta(Request $request){
        
        $MetaData = Admin::where('id', 1)->first();
        
        $data=[
            
            'meta_title' => $MetaData->meta_jobtitle,
            'meta_description' => $MetaData->meta_jobdescription,
            'meta_keyword' => $MetaData->meta_jobkeywords
            ];
            
        return Response(['response' => $data, 'status' => 200], 200);
    }
    
    public function jobDescriptionMeta(Request $request, $slug){
        
        $MetaData = Job::where('slug', $slug)->first();
        
        $data=[
            
            'meta_title' => $MetaData->meta_title,
            'meta_description' => $MetaData->meta_description,
            'meta_keyword' => $MetaData->meta_keyword
            ];
            
        return Response(['response' => $data, 'status' => 200], 200);
    }
    
    public function categorylistingMeta(Request $request){
        
        $MetaData = Admin::where('id', 1)->first();
        
        $data=[
            
            'meta_title' => $MetaData->meta_catetitle,
            'meta_description' => $MetaData->meta_catedescription,
            'meta_keyword' => $MetaData->meta_catekeywords
            ];
            
        return Response(['response' => $data, 'status' => 200], 200);
    }
    
    public function blogpageMeta(Request $request, $slug){
        
        $MetaData = Blog::where('slug', $slug)->first();
        
        $data=[
            
            'meta_title' => $MetaData->meta_title,
            'meta_description' => $MetaData->meta_description,
            'meta_keyword' => $MetaData->meta_keyword
            ];
            
        return Response(['response' => $data, 'status' => 200], 200);
    }
    
    public function staticPageMeta(Request $request, $slug){
        
        $MetaData = Page::where('static_page_heading','=',$slug)->first();
        
        $data=[
            
            'meta_title' => $MetaData->meta_title,
            'meta_description' => $MetaData->meta_description,
            'meta_keyword' => $MetaData->meta_keyword
            ];
            
        return Response(['response' => $data, 'status' => 200], 200);
    }
   

    
}
