<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Job;

class Category extends Model
{
    use HasFactory;
    protected $guarded = []; 
    public $timestamps = false;
    
    // public function jobs()
    // {
    //     return $this->hasMany(Job::class, 'category_id', 'id');

    // }


    public function getCategoryList(){
        $categories = $this->where('status',1)
        ->where('parent_id',0)
        // ->withCount('jobs') // Add count of related jobs
        ->select('id','name','slug')
        ->orderBy('name','asc')
        ->get();

        return $categories;
    }

    public function getSubCategoryList($categoryId) {
        $categories = $this->where('status',1)
        ->where('parent_id',$categoryId)
        ->select('id','name','slug')
        ->orderBy('name','asc')
        ->get();

        return $categories;
    }
}
